/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPClassPath;
import com.sun.javaws.security.Resource;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.awt.AppContext;

public final class JNLPClassLoader
extends SecureClassLoader {
    private static JNLPClassLoader _instance = null;
    private LaunchDesc _launchDesc = null;
    private JNLPClassPath _jcp = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;

    public JNLPClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    private void initialize(LaunchDesc launchDesc, boolean bl, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._jcp = new JNLPClassPath(launchDesc, bl);
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
    }

    public static synchronized JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            _instance = classLoader instanceof JNLPClassLoader ? (JNLPClassLoader)classLoader : new JNLPClassLoader(classLoader);
        }
        return _instance;
    }

    public static synchronized JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, launchDesc.isApplet(), appPolicy);
        }
        return jNLPClassLoader;
    }

    public static synchronized JNLPClassLoader getInstance() {
        return _instance;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public void downloadResource(URL uRL, String string, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadResource(this._launchDesc, uRL, string, downloadProgress, bl);
    }

    public void downloadParts(String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadParts(this._launchDesc, stringArray, downloadProgress, bl);
    }

    public void downloadExtensionParts(URL uRL, String string, String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadExtensionPart(this._launchDesc, uRL, string, stringArray, downloadProgress, bl);
    }

    public void downloadEager(LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadEagerorAll(this._launchDesc, false, downloadProgress, bl);
    }

    public JARDesc getJarDescFromFileURL(URL uRL) {
        return this._jcp.getJarDescFromFileURL(uRL);
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public URL getResource(String string) {
        URL uRL = null;
        for (int i = 0; uRL == null && i < 3; ++i) {
            Trace.println((String)("Looking up resource: " + string + " (attempt: " + i + ")"), (TraceLevel)TraceLevel.BASIC);
            uRL = super.getResource(string);
        }
        return uRL;
    }

    public String findLibrary(String string) {
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        string = Config.getInstance().getLibraryPrefix() + string + Config.getInstance().getLibrarySufix();
        Trace.println((String)("Looking up native library: " + string), (TraceLevel)TraceLevel.BASIC);
        File[] fileArray = LaunchDownload.getNativeDirectories(this._launchDesc);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(fileArray[i], string);
            if (!file.exists()) continue;
            Trace.println((String)("Native library found: " + file.getAbsolutePath()), (TraceLevel)TraceLevel.BASIC);
            return file.getAbsolutePath();
        }
        Trace.println((String)"Native library not found", (TraceLevel)TraceLevel.BASIC);
        return super.findLibrary(string);
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        Trace.println((String)("Loading class " + string), (TraceLevel)TraceLevel.BASIC);
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = JNLPClassLoader.this._jcp.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return JNLPClassLoader.this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this._acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            object = this.getPackage((String)object2);
            Manifest manifest = resource.getManifest();
            if (object != null) {
                boolean bl;
                if (((Package)object).isSealed()) {
                    bl = ((Package)object).isSealed(uRL);
                } else {
                    boolean bl2 = bl = manifest == null || !this.isSealed((String)object2, manifest);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (manifest != null) {
                this.definePackage((String)object2, manifest, uRL);
            } else {
                this.definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object2 = resource.getBytes();
        object = Globals.isJavaVersionAtLeast15() ? new CodeSource(uRL, resource.getCodeSigners()) : new CodeSource(uRL, resource.getCertificates());
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(final String string) {
        if (!this._initialized) {
            return super.findResource(string);
        }
        Resource resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JNLPClassLoader.this._jcp.getResource(string, true);
            }
        }, this._acc);
        return resource != null ? this._jcp.checkURL(resource.getURL()) : null;
    }

    public Enumeration findResources(final String string) throws IOException {
        if (!this._initialized) {
            return super.findResources(string);
        }
        final Enumeration enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JNLPClassLoader.this._jcp.getResources(string, true);
            }
        }, this._acc);
        return new Enumeration(){
            private URL res;

            public Object nextElement() {
                if (this.res == null) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.res;
                this.res = null;
                return uRL;
            }

            public boolean hasMoreElements() {
                Resource resource;
                if (Thread.currentThread().getThreadGroup() == Main.getSecurityThreadGroup()) {
                    return false;
                }
                if (this.res != null) {
                    return true;
                }
                while ((resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        return enumeration.nextElement();
                    }
                }, JNLPClassLoader.this._acc)) != null) {
                    this.res = JNLPClassLoader.this._jcp.checkURL(resource.getURL());
                    if (this.res == null) continue;
                }
                return this.res != null;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        this._appPolicy.addPermissions(permissionCollection, codeSource);
        URL uRL = codeSource.getLocation();
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        JARDesc jARDesc = this._jcp.getJarDescFromFileURL(uRL);
        if (jARDesc != null) {
            object = Cache.getBaseDirsForHost(jARDesc.getLocation());
            for (int i = 0; i < ((String[])object).length; ++i) {
                Object object2 = object[i];
                if (object2 == null) continue;
                object2 = ((String)object2).endsWith(File.separator) ? (String)object2 + '-' : (String)object2 + File.separator + '-';
                permissionCollection.add(new FilePermission((String)object2, "read"));
            }
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
                permission = new FilePermission((String)object, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object = uRL.getFile().replace('/', File.separatorChar);
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
            }
            permission = new FilePermission((String)object, "read");
        } else {
            String string;
            object = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((string = ((URL)object).getHost()) != null && string.length() > 0) {
                permission = new SocketPermission(string, "connect, accept");
            }
        }
        if (permission != null) {
            object = System.getSecurityManager();
            if (object != null) {
                Permission permission2 = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object, permission2){
                    private final /* synthetic */ SecurityManager val$sm;
                    private final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this._acc);
            }
            permissionCollection.add(permission);
        }
        if (!permissionCollection.implies(new AWTPermission("accessClipboard"))) {
            AppContext.getAppContext().put("UNTRUSTED_CLIPBOARD_ACCESS_KEY", Boolean.TRUE);
        }
        return permissionCollection;
    }

    public final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
        return super.loadClass(string, bl);
    }
}

