/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java2d.fontchecker;

import com.sun.java2d.fontchecker.FontCheckerConstants;
import com.sun.java2d.fontchecker.FontFileFilter;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Timer;
import sun.font.FontManager;

public class FontChecker
implements ActionListener,
FontCheckerConstants {
    private PrintWriter procPipeOut;
    private BufferedInputStream procPipeIn;
    private Process childProc;
    private String outputFile;
    private Thread currThread;
    private Timer timeOne;
    private Timer timeAll;
    private static int timeoutOne = 10000;
    private static int timeoutAll = 120000;
    private boolean checkNonTTF = false;
    private Vector badFonts = new Vector();
    private static boolean verbose = false;
    private static String javaCmd = "java";

    static void printlnMessage(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timeOne) {
            this.timeOne.stop();
            FontChecker.printlnMessage("Child timed out: killing");
            this.childProc.destroy();
        } else {
            this.doExit();
        }
    }

    public void initialize() {
        try {
            if (this.childProc != null) {
                this.childProc.destroy();
            }
            String string = System.getProperty("file.separator");
            String string2 = System.getProperty("java.home");
            String string3 = System.getProperty("java.class.path");
            string3 = "\"" + string3 + "\"";
            String string4 = "-cp " + string3 + " -Dsun.java2d.fontpath=\"" + string2 + string + "lib" + string + "fonts\"";
            String string5 = new String(string2 + string + "bin" + string + javaCmd + " -XXsuppressExitMessage " + string4 + " com.sun.java2d.fontchecker.FontCheckDummy");
            FontChecker.printlnMessage("cmd=" + string5);
            this.childProc = Runtime.getRuntime().exec(string5);
        }
        catch (IOException iOException) {
            FontChecker.printlnMessage("can't execute child process");
            System.exit(0);
        }
        catch (SecurityException securityException) {
            FontChecker.printlnMessage("Error: access denied");
            System.exit(0);
        }
        this.procPipeOut = new PrintWriter(this.childProc.getOutputStream());
        this.procPipeIn = new BufferedInputStream(this.childProc.getInputStream());
        try {
            int n = this.procPipeIn.read();
            if (n != 100) {
                FontChecker.printlnMessage("bad child process start status=" + n);
                this.doExit();
            }
        }
        catch (IOException iOException) {
            FontChecker.printlnMessage("can't read child process start status unknown");
            this.doExit();
        }
    }

    private void doExit() {
        try {
            if (this.procPipeOut != null) {
                this.procPipeOut.write(2 + System.getProperty("line.separator"));
                this.procPipeOut.flush();
                this.procPipeOut.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryFont(File file) {
        int n = 0;
        String string = file.getAbsolutePath();
        FontChecker.printlnMessage("Checking font " + string);
        this.currThread = Thread.currentThread();
        this.timeOne.restart();
        String string2 = Integer.toString(this.checkNonTTF ? 1 : 0) + string + System.getProperty("line.separator");
        this.procPipeOut.write(string2);
        this.procPipeOut.flush();
        if (this.procPipeOut.checkError()) {
            FontChecker.printlnMessage("Error: font crashed");
            this.initialize();
            return false;
        }
        try {
            n = this.procPipeIn.read();
        }
        catch (InterruptedIOException interruptedIOException) {
            FontChecker.printlnMessage("Error: timeout occured");
            this.initialize();
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.timeOne.stop();
            FontChecker.printlnMessage("Error: font crashed");
            this.initialize();
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            n = 62;
        }
        finally {
            this.timeOne.stop();
        }
        if (n == 65) {
            FontChecker.printlnMessage("Font integrity verified");
            return true;
        }
        if (n > 0) {
            switch (n) {
                case 60: {
                    FontChecker.printlnMessage("Error: font not found!");
                    break;
                }
                case 61: {
                    FontChecker.printlnMessage("Error: incorrect font format");
                    break;
                }
                case 62: {
                    FontChecker.printlnMessage("Error: exception reading font");
                    break;
                }
                case 64: {
                    FontChecker.printlnMessage("Error: can't display characters");
                    break;
                }
                case 10: {
                    FontChecker.printlnMessage("Error: font crashed");
                    break;
                }
                default: {
                    FontChecker.printlnMessage("Error: invalid error code:" + n);
                    break;
                }
            }
        } else if (n == -1) {
            FontChecker.printlnMessage("Error: end of stream marker encountered");
        } else {
            FontChecker.printlnMessage("Error: invalid error code:" + n);
        }
        this.initialize();
        return false;
    }

    public boolean checkFonts(boolean bl) {
        FontFileFilter fontFileFilter = new FontFileFilter(this.checkNonTTF);
        boolean bl2 = true;
        GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = FontManager.getFontPath((boolean)true);
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        this.timeOne = new Timer(timeoutOne, this);
        this.timeAll = new Timer(timeoutAll, this);
        this.timeAll.restart();
        block0: while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            File[] fileArray = file.listFiles(fontFileFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory() || this.tryFont(fileArray[i])) continue;
                bl2 = false;
                this.badFonts.add(fileArray[i].getAbsolutePath());
                if (!bl) continue block0;
            }
        }
        this.procPipeOut.write(2 + System.getProperty("line.separator"));
        this.procPipeOut.flush();
        this.procPipeOut.close();
        return bl2;
    }

    public static void main(String[] stringArray) {
        try {
            File file;
            System.setProperty("java.awt.headless", "true");
            System.setProperty("sun.java2d.noddraw", "true");
            boolean bl = true;
            boolean bl2 = false;
            FontChecker fontChecker = new FontChecker();
            for (int i = 0; i < stringArray.length && !bl2; ++i) {
                if (stringArray[i].equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (stringArray[i].equals("-w") && System.getProperty("os.name", "unknown").startsWith("Windows")) {
                    javaCmd = "javaw";
                    continue;
                }
                if (stringArray[i].equals("-o")) {
                    if (++i < stringArray.length) {
                        fontChecker.outputFile = stringArray[i];
                        continue;
                    }
                    FontChecker.printlnMessage("Error: invalid argument format");
                    bl2 = true;
                    continue;
                }
                FontChecker.printlnMessage("Error: invalid argument value");
                bl2 = true;
            }
            if (bl2 || fontChecker.outputFile == null) {
                System.exit(0);
            }
            if ((file = new File(fontChecker.outputFile)).exists()) {
                file.delete();
            }
            fontChecker.initialize();
            if (!fontChecker.checkFonts(bl)) {
                String[] stringArray2 = fontChecker.badFonts.toArray(new String[0]);
                if (stringArray2.length > 0) {
                    FontChecker.printlnMessage("Bad Fonts:");
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(fontChecker.outputFile);
                        PrintStream printStream = new PrintStream(fileOutputStream);
                        for (int i = 0; i < stringArray2.length; ++i) {
                            printStream.println(stringArray2[i]);
                            FontChecker.printlnMessage(stringArray2[i]);
                        }
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                FontChecker.printlnMessage("No bad fonts found.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }
}

